
#|__________________________________________________
 
 ViSta - The Visual Statistics System
 Copyright (c) 1991-2002 by Forrest W. Young
 For further information contact the author 
 forrest@visualstats.org
 http://www.visualstats.org

 VISTA.LSP - VISTA RUNTIME GUI CREATOR
 
 M A I N   P R O G R A M   E N T R Y   P O I N T

 The steps are

 A ViSta.exe is run somehow, either by a direct
   double-click, by a file which was double-clicked
   that has an extension that is associated with 
   ViSta, by a file downloaded over the internet,
   or by a user who double-clicks a shortcut
   that points to ViSta.

   In all cases the statinit.lsp file located in the
   home directory is loaded by XLispStat. 

 B Initialize the ViSta GUI
   Statinit loads in ViSta.lsp (this file). 
   ViSta now gets ready to construct the Vista GUI. 
   The following steps are taken to do this:
   (0) define and validate paths
   (1) determine if xlisp-only
         If xlisp-only, restart in xlisp-only mode
         If not xlisp-only continue.
   (2) backup preference files
   (3) set debugging options
   (4) initialize local variables
   (5) load phase 1 update file
   (6) prepare, but don't show, the logo splash screen.
   (7) prepare and start an idle process

This is the end of the code that is loaded as a result of XLispStat's statinit.lsp file. Because of this, it looks  for the ViStInit.lsp file to read. If it has one to read it does so and follows the specified code, if any.

At this point *logo* is created but not showing. ViSta creation code has not been read yet. The idle method is defined and on, waiting for an idle moment. If vista was run with a -f option, (as would be the case if a .vdf or .vaf file is double-clicked) the file is loaded and run before idling happens, so that whatever is in the file is done first. The usuala data or applet creates a variable whose value is the code for the data or applet.  This code is then evaluated at termination of startup. If no -f option is used, or if the idling method isn't overridden, then the default do-idle will read in the creation code. 

At startup, it is assumed that *logo* and *desktop* will be shown, so the variables *hide-logo* and *hide-vista* are usually initialized to nil.. The peculiar pause to check for input instructions unique to this run allows for the possibility of hiding the logo and desktop window, before anything else happens. This also minimizes the response time to the users double-click. 

The startup function constructs *startup-manager*, an instance of the startup manager prototype object, caries out the startup process defined by keyword STARTUP.  When the startup process becomes idle, the action defined by keyword ACTION is taken. The STARTUP keyword must have a value which is a function, with the default function being the (default-system-startup-process) function defined below. ACTION must be either a function or NIL, with the default value being NIL. The remaining keywords (hide-desktop, hide-logo, hide-datasheet, hide-xlispstat) must have values that are either T or NIL. They have default values specified, respectively, by the values of the global variables *HIDE-DESKTOP*, *HIDE-LOGO*, *HIDE-DATASHEET* and *HIDE-XLISPSTAT*. The (default-system-startup-process) function takes the appropriate action the logo, XLispStat window, desktop and datasheet.

We now turn to the (default-system-startup-process) function. This function is the default startup function used by the startup-manager-object (in file maketime\defun2.lsp). It completely determines the look and feel of the initial vista environment and could be replaced with another function. For some ways of starting up (e.g., when running excel) the process is altered.

The startup process is a series of four steps. The timing of the steps is controlled by the startup manager, which is an event-driven process (i.e., the next step starts when the manager's idle process indicates the previous step is completed). The steps are
  
STEPS B1 - B? Create ViSta

Use the (create-vista) function to construct and install the vista gui. At this point the value of *hide-logo* depends on the desktop preferences, being T or NIL. This value could be overridden by the  -f file. If *hide-logo* is NIL,  show the logo. The code for (create-vista) is in source/vista1.lsp
 
We create a new DO-IDLE for *LOGO* which will generate error message if desktop creation fails, and which opens vista desktop, if *HIDE-VISTA* is NIL, at the point that processing stops (when DO-IDLE is active). If logo window open, close it. Desktop GUI is now created, but not showing

 
STEPS C1 - C3 Creation Normal - Show ViSta

If *HIDE-VISTA* is NIL, show ViSta. Process data coming from from excel or elsewhere via dde. Process data coming from a vista data file (vdf) file, if any. Process program from an applet (vda) file, if any. If present read these and do associated startup function.


  
STEPS D! & D2 
Creation Error  - Show error message and stop
  


STEPS E1 - E? 
Take Optional User Startup Action & Save Environment. Follow instructions in vistinit.lsp file, if any
 

NOTE:
if compilation of this file gives an error message about
  "Cannot compile function after ABCD" and ABCD is actually
  the last function in this file, it is because another 
  copy of vista is running invisibly. To stop the other copy, 
  type (exit) until the resulting error message switches from 
  "transaction failed" to "cannot connect to xlispstat".
 
 |___________________________________________________________________ 
 |#










#|___________________________________________________________________ 
 |
 |  M A I N   P R O G R A M   E N T R Y   P O I N T
 |___________________________________________________________________ 
 |#




(setf *part* "A")
(setf *knt* 0)
(setf *startup-steps-title* "Startup ViSta - PART A: INITIALIZE")
(defun show-startup (string)
  (format t "~%~%; ~a~%" string)
  (let ((str (strcat "ViSta - " *part* " " (format nil "~a" *knt*))))
    (when (and (boundp '*desktop-container*) *desktop-container*)
          (send *desktop-container* :title str))
    (setf *vista-steps-dialog* (please-wait string :title str))
   ; (send *vista-steps-dialog* :title str)
    (setf *knt* (1+ *knt*))))
  



#|___________________________________________
 |
 | (0) X L I S P    O N L Y    M O D E
 |
 |     define current date and time
 |     define paths. check *default-path*
 |     see if XLispOnly mode. if so use,
 |     (xlisp) function to exit and restart   
 |___________________________________________
 |#

(make-vista-copyright) ;sets current year
(setf *update-string* nil)
(setf *date-time* (date-time))
(setf *date-time* (apply #'format nil "~a ~a ~a" (select *date-time* (list 2 0 1))))
(if *pro-version* (id-number) )


(setf *startup-path* (strcat (get-working-directory) "\\"))
(define-vista-paths)
(unless (and (boundp '*default-path*) 
             *default-path*
             (probe-file (strcat *default-path* "init.lsp")))
        (open-window)
        (fatal-message (format nil "Error in ViSta Initialization - Default Path ~a"
                               (boundp '*default-path*) nil "Unbound")))


(setf *xlispstat-only* 
      (equal (string-downcase 
              (msw-get-profile-string 
               "ViSta" "XLispOnly" (strcat *default-path* "wxls32.ini")))
             "yes"))
(when *xlispstat-only* (xlisp))


#|___________________________________________
 |
 | (1) V I S T A    M O D E
 |  
 |     Read .ini file for verbosity level
 |     Read PHASE 0 code modification files
 |___________________________________________
 |#

(setf *load-verbose* 
      (equal (string-downcase 
              (msw-get-profile-string 
               "ViSta" "LoadVerbose" (strcat *default-path* "wxls32.ini")))
             "yes"))

(setf *file-verbose* *load-verbose*)

(setf *startup-verbose* 
      (equal (string-downcase 
              (msw-get-profile-string 
               "ViSta" "StartupVerbose" (strcat *default-path* "wxls32.ini")))
             "yes"))

(setf *verbose* 
      (equal (string-downcase 
              (msw-get-profile-string 
               "ViSta" "Verbose" (strcat *default-path* "wxls32.ini")))
             "yes"))

(when *startup-verbose* 
      (show-startup "STEP A 0: Set Date. Check Paths, See if XLISPONLY or ViSta Mode"))

(when (load (strcat *default-path* "update\\phase0.lsp") :if-does-not-exist nil)
      (setf *updated* t))

(setf *hide-xlispstat* t)

(let* ((level (string-downcase 
               (msw-get-profile-string 
                "ViSta" "Verbosity" (strcat *default-path* "wxls32.ini")))))

  (when (> (number-from-string level) 2) 
        (format t "~%ViSta Invocation Log~%")
        (setf *log* 
              (equal (string-downcase 
                      (msw-get-profile-string 
                       "ViSta" "Log" (strcat *default-path* "wxls32.ini")))
                     "yes"))

        (setf *debug-mode* 
              (debug-mode (equal (string-downcase 
                                  (msw-get-profile-string 
                                   "ViSta" "Debug" (strcat *default-path* "wxls32.ini")))
                                 "yes"))))

  (when (> (number-from-string level) 0) 
        (show-startup "STEP A 1: VISTA MODE! Read Phase 0 files. Set verbosity")
        (format t "; ~a~%" *date-time*)
        (format t "; Default Path is ~a~%~%" *default-path*)
        (format t "~%; Verbosity Level: ~a~%" level))

  (verbosity (number-from-string level))
  
  (when (> *verbosity* 0) (terpri) )
  )




#|___________________________________________
 |
 | (2) Read PHASE 1 code modification files
 |___________________________________________
 |#


(when *startup-verbose* 
      (show-startup "STEP A 2: Read PHASE 1 code modification files"))

(when (load (strcat *default-path* "update\\phase1.lsp") :if-does-not-exist nil)
      (setf *updated* t))




#|___________________________________________
 |
 | (3) Indicate ViSta is running
 |     Back up preference files
 |___________________________________________
 |#



(when *startup-verbose* (show-startup "STEP A 3: Back up preference files")(terpri))

(msw-write-profile-string "ViSta" "ViStaRunning" "Yes" (strcat *default-path* "wxls32.ini"))
(backup-prefs-files)
    

#|___________________________________________
 |
 | (4) Show XLispStat window when asked to
 |___________________________________________
 |#


(when *startup-verbose* (show-startup "STEP A 4: Show XLispStat window when asked to"))

(setf *Hide-XLispStat* 
        (equal "yes" 
               (string-downcase (msw-get-profile-string 
                                 "ViSta" "HideXLispStat" 
                                 (strcat *default-path* "wxls32.ini")))))

(when (and (not *hide-xlispstat*)
           (equal "yes" (string-downcase (msw-get-profile-string 
                                         "XLisp" "HideMainFrame" 
                                          (strcat *default-path* "wxls32.ini")))))
      (xlispstat-window)) 

(setf *doco-mode* 
      (equal (string-downcase 
              (msw-get-profile-string 
               "ViSta" "DocoMode" (strcat *default-path* "wxls32.ini")))
             "yes")) 



#|________________________________________________
 | (5) Initialize variables - Read prefload
 |
 |    *run-number*   read, add 1, save in prefload
 |    *hide-logo*    initialize to nil
 |    *hide-vista*   use value in prefload file
 |    *verbose*      if not t, check verbose file
 |    *date-time*    initialize to current value
 |    *pro-version*  initialize
 |    *logo*         nil
 |    *create-vista* t
 |    *vista-exists* nil
 |________________________________________________
 |#

(when *startup-verbose* (show-startup "STEP A 5: Initialize variables and read prefload"))
(vista-release-numbers)
(setf *invoked-date* (apply #'format nil "~a ~a ~a" (select (date-time) '(2 0 1))))
(unless (boundp '*coming-from-xlisp*) (format t "~a" *xls-mod-copyright*))
(load (strcat *prefs-path* "prefload"))
(setf *run-number* (if (< *run-number* -5) 1 (1+ *run-number*)))
;next statement must go after reading prefload
(write-prefload-file);updates *run-number*
(setf *doco-screen-size* '(600 420))
(setf *min-desktop-container-size* 
      (mapcar #'max *doco-screen-size* (floor (* 2/3 (effective-screen-size)))))
(setf *effective-screen-size* (if *doco-mode* *doco-screen-size* (effective-screen-size)))
(unless *verbose* 
        (load (strcat *prefs-path* "verbose"))
        (when  *MAKE-VERBOSE-MODE* (verbose t t))
        (when (or *verbose* *visible-startup*) (listeners)))
;(when (> *verbosity* 1) (listeners))
(make-vista-copyright) ;sets current year
(setf *update-string* nil)
(setf *date-time* (date-time))
(setf *date-time* (apply #'format nil "~a ~a ~a" (select *date-time* (list 2 0 1))))
(if *pro-version* (id-number) )
(setf *create-vista* t)
(setf *vista-exists* nil)
(setf *hide-desktop* 
      (equal (string-downcase 
              (msw-get-profile-string 
               "ViSta" "HideDeskTop" (strcat *default-path* "wxls32.ini")))
             "yes")) 

(setf *show-xlispstat* (not *hide-xlispstat*))



#|________________________________________________
 |
 | (6) Print Copyright and Header
 |________________________________________________
 |#


(when *startup-verbose* (show-startup "STEP A 6: Print Copyright and header"))

(pretty-copyrights)

(FORMAT T "~2%~A~2%" *DATE-TIME*)

(if *verbose* (version))




#|___________________________________________
 |
 | (7) create, but dont show, logo and
 |     prepare initial presentations
 |___________________________________________
 |# 

(when *startup-verbose* (show-startup "STEP A 7: Create but do not show Logo"))

(setf *logo* (splash-screen :static t :show nil))
(send *logo* :title " ")




#|___________________________________________
 |
 | (8) STARTUP VISTA
 |___________________________________________
 |#

(when *startup-verbose* (show-startup "STEP A 8: StartUp: Begin ViSta Creation"))

;lispbossrunning is set to yes by lispboss at startup of lispboss 
;                and is set to nil by lispboss at exit of lispboss

;lispbossstartedvista is set to yes by lispboss at startup of lispboss 
;                     and is set to nil by vista at exit of vista

;(when (equal "No" (msw-get-profile-string 
;                   "ViSta" "LispBossStartedViSta" (strcat *default-path* ;"wxls32.ini")))
;      (msw-write-profile-string 
;       "ViSta" "InFile" "No" (strcat *default-path* "wxls32.ini")))
   
      
(when (equal "Yes" (msw-get-profile-string 
                    "ViSta" "LispBossRunning" (strcat *default-path* "wxls32.ini")))
      (msw-write-profile-string 
       "ViSta" "LispBossRunning" "No" (strcat *default-path* "wxls32.ini")))

(startup)